<?php
	global $wpdb;
	require_once(ABSPATH . 'wp-admin/upgrade-functions.php');
	
	//Определение версии mysql
	if ( version_compare($wpdb->db_version(), '4.1.0', '>=') ) {
		if ( ! empty($wpdb->charset) )
			$charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
		if ( ! empty($wpdb->collate) )
			$charset_collate .= " COLLATE $wpdb->collate";
	}
	add_option('css_template', 'default.css');
	
	## seoanalyzer
	$sql_table_vipusers = "
		CREATE TABLE `".$wpdb->prefix."seoanalyzer` (
			`ID` int(10) unsigned NOT NULL auto_increment,
			`seourl` varchar(100) NOT NULL,
			`fullurl` text NOT NULL,
			`title` text NOT NULL,
			`description` text NOT NULL,
			`keywords` text NOT NULL,
			`cms` text NOT NULL,
			`domainage` varchar(100),
			`siteupdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
			`robot` int(10) NOT NULL default '0',
			`sitemap` int(10) NOT NULL default '0',
			`pagespeed_d` int(10) NOT NULL default '0',
			`pagespeed_m` int(10) NOT NULL default '0',
			`w3HTML` int(10) NOT NULL default '0',
			`w3CSS` int(10) NOT NULL default '0',
			`pagesize` int(10) NOT NULL default '0',
			`speed` varchar(100) NOT NULL default '0',
			`ip` varchar(15) NOT NULL DEFAULT '',
			`city` text NOT NULL,
			`map` text NOT NULL,
			`dns` text NOT NULL,
			`webserver` text NOT NULL,
			`charset` text NOT NULL,
			`whois` longtext NOT NULL,
			`google_bl` int(100) NOT NULL default '0',
			`google_ip` int(100) NOT NULL default '0',
			`bing_bl` int(100) NOT NULL default '0',
			`bing_ip` int(100) NOT NULL default '0',
			`yahoo_bl` int(100) NOT NULL default '0',
			`yahoo_ip` int(100) NOT NULL default '0',
			`cy` int(100) NOT NULL default '0',
			`alexarank` int(100) NOT NULL default '0',
			`yandex_cat` int(100) NOT NULL default '0',
			`dmoz` int(100) NOT NULL default '0',
			`facebook_likes` int(100) NOT NULL default '0',
			`facebook_share` int(100) NOT NULL default '0',
			`facebook_comments` int(100) NOT NULL default '0',
			`twitter_share` int(100) NOT NULL default '0',
			`pinterest_share` int(100) NOT NULL default '0',
			`gplus` text NOT NULL,
			`linkedin` int(100) NOT NULL default '0',
			`stumbledupon` int(100) NOT NULL default '0',
			`vk` int(100) NOT NULL default '0',
			`myworld` int(100) NOT NULL default '0',
			`ok` int(100) NOT NULL default '0',
			PRIMARY KEY  (`ID`)
		)".$charset_collate." AUTO_INCREMENT=1;";
		
	//Проверка на существование таблицы	
	if ( $wpdb->get_var("SHOW TABLES LIKE '".$wpdb->prefix . 'seoanalyzer'."'") != $wpdb->prefix . 'seoanalyzer' ) {
		dbDelta($sql_table_vipusers);
	}
	
	$upload = wp_upload_dir();
	$upload_dir = $upload['basedir'];
	$upload_dir = $upload_dir . '/siteshot';
	if ( ! wp_mkdir_p( $upload_dir ) ){
	   echo "Не удалось создать каталог siteshot";
	}
	
	/*if (get_option('permalink_structure')){
		//permalinks enabled
	}else{
		global $wp_rewrite;
		$wp_rewrite->set_permalink_structure('/%year%/%monthnum%/%day%/%postname%/');
	}*/
	/*if (is_writable($upload_dir)) {
    	//echo 'The file is writable';
	} else {
    	chmod($upload_dir, 0755);
	}
	$cache_dir = SEO_ANALYZER_INC_URL.'/cache';
	if (is_writable($cache_dir)) {
    	//echo 'The file is writable';
	} else {
    	chmod($cache_dir, 0755);
	}*/
	
?>